﻿/**
 * Use this class to encrypt a passed string and decrypt an already encrypted string. The class uses a simple substitution cypher for the encryption. If you are very serious about the security of your applications, better consider other alternatives like databases, stronger encryption algorithms, etc than using this class.
 */

class EncryptDecrypt 
{	
	/**
	 * Use this function to encrypt a string
	 * @param	str - the string to be encrypted
	 * @return the encrypted string
	 */
	public static function encrypt(str:String):String {
		var encstr:String = "";
		var encmap:Array = new Array("l","x","f","w","n","s","z","a","p","o","t","d","m","e","r","h","y","c","k","u","b","i","g","q","v","j");
		var encrevmap:Array = new Array("j","v","q","g","i","b","u","k","c","y","h","r","e","m","d","t","o","p","a","z","s","n","w","f","x","l");
		var encset:Array = new Array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z");
		for(var i:Number=0; i<str.length; i++){
			var loc:Number;
			loc = findStr(str.charAt(i), encset);
			if(loc != -1){
				encstr += encmap[loc];
			}else{
				encstr += str.charAt(i);
			}
		}
		var temp:String = "";
		for(var i:Number=0; i<encstr.length; i++){
			var loc:Number;
			loc = findStr(encstr.charAt(i), encset);
			if(loc != -1){
				temp += encrevmap[loc];
			}else{
				temp += str.charAt(i);
			}
		}
		encstr = temp;
		temp = "";
		for(var i:Number=(encstr.length-1);i>=0;i--){
			temp += encstr.charAt(i);
		}
		encstr = "<encryptedtext><![CDATA[" + temp + "]]></encryptedtext>";
		return encstr
	}

	/**
	 * Use this function to decrypt a string
	 * @param	str - the string to be decrypted
	 * @return the decrypted string
	 */
	public static function decrypt(str:String):String {
		var encmap:Array = new Array("l","x","f","w","n","s","z","a","p","o","t","d","m","e","r","h","y","c","k","u","b","i","g","q","v","j");
		var encrevmap:Array = new Array("j","v","q","g","i","b","u","k","c","y","h","r","e","m","d","t","o","p","a","z","s","n","w","f","x","l");
		var encset:Array = new Array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z");
		var dec:String = "";
		var encstr:String = str;
		for(var i:Number=0; i<encstr.length; i++){
			var loc:Number;
			loc = findStr(encstr.charAt(i), encrevmap);
			if(loc != -1){
				dec += encset[loc];
			}else{
				dec += encstr.charAt(i);
			}
		}
		var temp:String = "";
		for(var i:Number=0; i<dec.length; i++){
			var loc:Number;
			loc = findStr(dec.charAt(i), encmap);
			if(loc != -1){
				temp += encset[loc];
			}else{
				temp += dec.charAt(i);
			}
		}
		dec = temp;
		temp = "";
		for(var i:Number=(dec.length-1);i>=0;i--){
			temp += dec.charAt(i);
		}
		dec = temp
		return dec;
	}
	
	private static function findStr(str:String, arr:Array):Number{
		var res:Number = -1;
		for(var j:Number=0;j<arr.length;j++){
			if(str == arr[j]){
				res = j;
				break;
			}
		}
		return res;
	}
}