﻿import mx.utils.Delegate;
import mx.video.*;
import mx.events.EventDispatcher;

/**
 * This class is the video that is displayed in the background in the gallery. The following events are dispatched by this class:<br/><br/>
 * <b><i>BGVideoStarted</i></b> - dispatched when the playback of the video is started<br/><br/>
 * <b><i>BGVideoStopped</i></b> - dispatched when the playback of the video is stopped<br/><br/>
 */
class bgswitcher.BGVideo extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(BGVideo.prototype); 
	
	private var mdobj:Object;
	private var bg_vid:Video;
	private var my_ns:NetStream;
	private var my_nc:NetConnection;
	private var _loop:Boolean;
	
	public function BGVideo() 
	{
		my_nc = new NetConnection();
	
		my_nc.connect(null);
	
		my_ns = new NetStream(my_nc);
		
		_visible = false;
		
		_loop = false;
	}
	
	/**
	 * Use this method to play a video file
	 * @param	str - the path to the video file
	 */
	public function playVideo(str:String) {
		
		my_ns.setBufferTim(5);
	
		bg_vid.smoothing = true;
	
		bg_vid.attachVideo(my_ns);
	
		my_ns["onMetaData"] = Delegate.create(this, function(mobj) {
		
			mdobj = mobj;
		
			_visible = true;
		});
		
		my_ns.onStatus = Delegate.create(this, function(info) {
			if (info.code == "NetStream.Play.Start") {
				dispatchEvent( { type:"BGVideoStarted" } );
			}
			if (info.code == "NetStream.Play.Stop") {
				if (loop) {
					my_ns.seek(0);
				}else {
					dispatchEvent( { type:"BGVideoStopped" } );
				}
			}
		});
		
		my_ns.play(str);
	}
	
	public function addEventListener() { };
	public function removeEventListener() { };
	private function dispatchEvent() { };
	
	/**
	 * Use this function to stop the video
	 */
	public function stopVideo() {
		my_ns.close();
	}
	
	/**
	 * Use this property to get or set whether the video loops or not
	 */
	public function get loop():Boolean {
		return _loop;
	}
	
	public function set loop(bool:Boolean) {
		_loop = bool;
	}
	
}