﻿import com.maheshj.utils.ImageLoader;
import mx.utils.Delegate;
import mx.events.EventDispatcher;
import caurina.transitions.*;

/**
 * This class is the backgound of the gallery into which the images load and all the cool masking transitions happen. The following events are dispatched by this class:<br/><br/>
 * <b><i>ImageLoaded</i></b> - dispatched when the image is loaded<br/><br/>
 * <b><i>ImageLoading</i></b> - Helps you keep track of the load progress of the image. The event has the following properties:<br/>
 * 		<i>progress</i> - It is a number less than or equal to one denoting the progress of the image.
 */
class bgswitcher.BgImage extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(BgImage.prototype); 
	
	private var img_il:ImageLoader;
	private var b_mc:MovieClip;
	private var a_mc:MovieClip;
	private var imgwidth:Number;
	private var imgheight:Number;
	private var c_mc:MovieClip;
	private var fadeease:String;
	private var fadetime:Number;
	private var imgtype:String;
	
	public function BgImage() 
	{	
		//fadeease = "easeInQuart";
		//fadetime = 1;
		
		img_il = new ImageLoader(this);
		img_il.onLoadProgress = Delegate.create(this, function(t_mc:MovieClip, bl:Number, bt:Number) {
			dispatchEvent( { type:"ImageLoading", progress:(bl / bt) } );
		});
		img_il.addEventListener("loadInit", Delegate.create(this, function(e:Object) {
			dispatchEvent( { type:"ImageLoaded" } );
			c_mc._visible = false;
			resize();
			var w:Number = c_mc.mask_mc._width;
			c_mc.mask_mc._width = 0;
			c_mc._visible = true;
			if (c_mc == a_mc) {
				Tweener.addTween(b_mc.mask_mc, { _width:0, time:(Stage.width/1000)*0.4, transition:"easeInOutQuart" } );
			}else {
				Tweener.addTween(a_mc.mask_mc, { _width:0, time:(Stage.width/1000)*0.4, transition:"easeInOutQuart" } );
			}
			Tweener.addTween(c_mc.mask_mc, { _width:w, time:(Stage.width/1000)*0.4, delay:(Stage.width/1000)*0.5, transition:"easeInOutQuart", onComplete:Delegate.create(this, function() {
				resize(imgwidth, imgheight);
				if (c_mc == a_mc) {
					b_mc._visible = false;
				}else {
					a_mc._visible = false;
				}
				dispatchEvent( { type:"ImageLoadInit" } );
			} ) } );
		}));
		
		onEnterFrame = Delegate.create(this, function() {
			a_mc.vid_mc.addEventListener("BGVideoStopped", Delegate.create(this, function(e:Object) {
				dispatchEvent( { type:"BGVideoStopped" } );
			}));
		
			b_mc.vid_mc.addEventListener("BGVideoStopped", Delegate.create(this, function(e:Object) {
				dispatchEvent( { type:"BGVideoStopped" } );
			}));
			
			a_mc.vid_mc.addEventListener("BGVideoStarted", Delegate.create(this, function(e:Object) {
				dispatchEvent( { type:"BGVideoStarted" } );
			}));
		
			b_mc.vid_mc.addEventListener("BGVideoStarted", Delegate.create(this, function(e:Object) {
				dispatchEvent( { type:"BGVideoStarted" } );
			}));
			
			delete onEnterFrame;
		});
		
		c_mc = a_mc;
	}
	
	/**
	 * Use this method to load any image.
	 * @param	path - path of the image to be loaded
	 */
	public function loadImage(path:String) {
		if (imgtype == "video") {
			c_mc.vid_mc.stopVideo();
		}
		b_mc.swapDepths(a_mc);
		if (c_mc == b_mc) {
			c_mc = a_mc;
		}else {
			c_mc = b_mc;
		}
		c_mc.holder_mc._visible = true;
		c_mc.vid_mc._visible = false;
		img_il.loadimg(path, c_mc.holder_mc);
		imgtype = "image";
	}
	
	/**
	 * Use this method to load a video.
	 * @param	path - path of the video to be loaded
	 */
	public function loadVideo(path:String) {
		b_mc.swapDepths(a_mc);
		if (c_mc == b_mc) {
			c_mc = a_mc;
		}else {
			c_mc = b_mc;
		}
		c_mc.holder_mc._visible = false;
		c_mc.vid_mc._visible = true;
		c_mc.vid_mc.playVideo(path);
		imgtype = "video";
		c_mc._alpha = 0;
		resize();
		c_mc._visible = true;
		Tweener.addTween(c_mc, { _alpha:100, time:fadetime, transition:fadeease, onComplete:Delegate.create(this, function() {
			resize(imgwidth, imgheight);
			dispatchEvent( { type:"ImageLoaded" } );
			if (c_mc == a_mc) {
				b_mc._visible = false;
			}else {
				a_mc._visible = false;
			}
		} ) } );
	}
	
	/**
	 * Use this function to resize the background to certain dimensions
	 * @param	w - value for the width
	 * @param	h - value for the height
	 */
	public function resize(w:Number, h:Number) {
		if ((w != undefined) and (h != undefined)) {
			imgwidth = w;
			imgheight = h;
			with (a_mc.mask_mc) {
				_width = w;
				_height = h;
			}
			with (b_mc.mask_mc) {
				_width = w;
				_height = h;
			}
		}
			resizeImg(c_mc);
	}
	
	private function resizeImg(mc:MovieClip) {
		var w:Number = c_mc.mask_mc._width;
		var h:Number = c_mc.mask_mc._height;
		var scale:Number = 100;
		if (imgtype == "image") {
			with (mc.holder_mc) {
				_xscale = 100;
				_yscale = 100;
			}
			if (w / h > mc.holder_mc._width / mc.holder_mc._height) {
				scale = (w / mc.holder_mc._width) * 100;
			}else {
				scale = (h / mc.holder_mc._height) * 100;
			}
			mc.holder_mc._xscale = scale;
			mc.holder_mc._yscale = scale;
			mc.holder_mc._x = (w - mc.holder_mc._width) / 2;
			mc.holder_mc._y = (h - mc.holder_mc._height) / 2;
		}
		if (imgtype == "video") {
			with (mc.vid_mc) {
				_xscale = 100;
				_yscale = 100;
			}
			if (w / h > mc.vid_mc._width / mc.vid_mc._height) {
				scale = (w / mc.vid_mc._width) * 100;
			}else {
				scale = (h / mc.vid_mc._height) * 100;
			}
			mc.vid_mc._xscale = scale;
			mc.vid_mc._yscale = scale;
			mc.vid_mc._x = (w - mc.vid_mc._width) / 2;
			mc.vid_mc._y = (h - mc.vid_mc._height) / 2;
		}
	}
	
	public function addEventListener() { };
	public function removeEventListener() { };
	private function dispatchEvent() { };
	
	/**
	 * Use this property to set the fade in/out ease type for the bg images. The value can be any of the supported ease types of tweener.
	 */
	public function set fadeEaseType(type:String) {
		fadeease = type;
	}
	
	/**
	 * Use this property to set the fade in/out time for the bg images.
	 */
	public function set fadeTime(time:Number) {
		fadetime = time;
	}
	
	/**
	 * Use this property to get or set wether the video loops or not.
	 */
	public function get loopVideo():Boolean {
		return a_mc.vid_mc.loop;
	}
	
	public function set loopVideo(bool:Boolean) {
		a_mc.vid_mc.loop = bool;
		b_mc.vid_mc.loop = bool;
	}
	
	/**
	 * Use this property to know if the image currently being displayed is an image or video.
	 */
	public function get isVideo():Boolean {
		var bool:Boolean;
		if (imgtype == "video") {
			bool = true;
		}else {
			bool = false;
		}
		return bool;
	}
}