﻿import mx.utils.Delegate;
import caurina.transitions.Tweener;

/**
 * This class is taken up by each menu item that appears in the bottom menu.
 */
dynamic class imagegal.BottomMenuItem extends MovieClip
{
	public var label_txt:TextField;
	private var ul_mc:MovieClip;
	
	public function BottomMenuItem() 
	{
		ul_mc._visible = false;
		
		label_txt.autoSize = true;
		
		onRollOver = Delegate.create(this, function() {
			ul_mc._visible = true;
			Tweener.addTween(ul_mc, { _width:label_txt._width-3.5, time:0.6, transition:"easeOutQuint" } );
		});
		
		onRollOut = onReleaseOutside = Delegate.create(this, function() {
			if(!isActive)
			Tweener.addTween(ul_mc, { _width:1, time:0.3, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
				ul_mc._visible = false;
			}) } );
		});
	}
	
	public function set isEnabled(bool:Boolean) {
		if (!bool) {
			enabled = false;
			Tweener.addTween(ul_mc, { _width:1, time:0.3, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
				ul_mc._visible = false;
				Tweener.addTween(this, { _alpha:50, transition:"easeInQuad", time:0.3 } );
			}) } );
		}else {
			if (enabled == false) {
				enabled = true;
				Tweener.addTween(this, { _alpha:100, transition:"easeInQuad", time:0.3 } );
			}
		}
	}
	
}