﻿import mx.data.types.Obj;
import mx.events.EventDispatcher;
import mx.utils.Delegate;
import com.maheshj.utils.IXML;

/**
 * This is the thumb list class for the gallery. It actually forms the <i>content_mc</i> movieclip of <i>VerticalScrollBox</i> class used in this file. The scrollbox helps to scroll through the thumbnails items.<br/><br/>
 * The following events are dispatched by this class:<br/><br/>
 * <b><i>ThumbClicked</i></b> - dispatched when the a thumb is clicked. The <i>loadObj</i> property of the event object has all the datails required to load the right image when a thumbnails is clicked. The 'before' image is retrieved as <i>loadObj.bimg</i> and the 'after' as <i>loadObj.aimg</i>.<br/><br/>
 * <b><i>ThumbListInit</i></b> - dispatched afer the initialization of the list<br/><br/>
 */
class imagegal.ThumbList extends MovieClip
{
	private static var EventDispatcherDependancy = EventDispatcher.initialize(ThumbList.prototype);
	
	private var _isactive:Boolean;
	private var thumbarr:Array;
	private var infoarr:Array;
	private var thumbs_xml:XML;
	private var _twidth:Number;
	private var _theight:Number;
	private var _gap:Number;
	private var _col:Number;
	private var total:Number;
	
	public function ThumbList() 
	{
		thumbarr = new Array();
		
		thumbs_xml = IXML.createXML();
		
		thumbs_xml.onLoad = Delegate.create(this, processXML);
		
		_isactive = false;
		
		total = 0;
	}
	
	/**
	 * Use this method to load gallery XML file.
	 * @param	path - path of the XML file
	 */
	public function loadXML(path:String) {
		thumbs_xml.load(path);
	}
	
	private function processXML(success) {
		if (success) {
			_twidth = thumbs_xml.firstChild.attributes.thumbwidth;
			_theight = parseInt(thumbs_xml.firstChild.attributes.thumbheight);
			_gap = parseInt(thumbs_xml.firstChild.attributes.gap);
			_col = parseInt(thumbs_xml.firstChild.attributes.columns);
			
			for (var i:Number = 0; i < total; i++) 
			{
				this["thumb" + i + "_mc"].removeMovieClip();
			}
			
			total = thumbs_xml.firstChild.childNodes.length
			
			var newx:Number = 0;
			
			var newy:Number = 0;
			
			for (var i:Number = 0; i < thumbs_xml.firstChild.childNodes.length; i++) 
			{
				var myid:String;
				var title:String;
				var info:String;
				var thumb:String;
				var img:String;
				var type:String;
				var initobj:Object = new Object();
			
				for (var j:Number = 0; j < thumbs_xml.firstChild.childNodes[i].childNodes.length; j++) 
				{
					if (thumbs_xml.firstChild.childNodes[i].childNodes[j].nodeName == "ID") {
						myid = thumbs_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
					if (thumbs_xml.firstChild.childNodes[i].childNodes[j].nodeName == "title") {
						title = thumbs_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
					if (thumbs_xml.firstChild.childNodes[i].childNodes[j].nodeName == "desc") {
						info = thumbs_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
					if (thumbs_xml.firstChild.childNodes[i].childNodes[j].nodeName == "thumb") {
						thumb = thumbs_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
					if (thumbs_xml.firstChild.childNodes[i].childNodes[j].nodeName == "image") {
						img = thumbs_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
					if (thumbs_xml.firstChild.childNodes[i].childNodes[j].nodeName == "type") {
						type = thumbs_xml.firstChild.childNodes[i].childNodes[j].firstChild.nodeValue;
					}
				}
				
				initobj.ID = myid;
				initobj.title = title;
				initobj.info = info;
				initobj.thumb = thumb;
				initobj.img = img;
				if (type != undefined) {
					initobj.type = type;
				}else {
					initobj.type = "image";
				}
				initobj.num = i;
				
				attachMovie("thumb", "thumb" + i + "_mc", i + 10, {_alpha:0, initObj:initobj } );
				
			}
			
			var xc:Number = 0;
			
			for (i = 0; i < thumbs_xml.firstChild.childNodes.length; i++) {
				this["thumb" + i + "_mc"].addEventListener("ThumbClicked", this);
				this["thumb" + i + "_mc"].addEventListener("ThumbLoaded", this);
				this["thumb" + i + "_mc"]._y = newy;
				this["thumb" + i + "_mc"]._x = newx;
				this["thumb" + i + "_mc"]._alpha = 100;
				xc++;
				if (xc == _col) {
					xc = 0;
					newy += 1 * _theight + 1 * _gap;
				}
				newx = xc * (1 * _twidth + 1 * _gap);
			}
			
			isActive = true;
			
			dispatchEvent( { type:"ThumbListInit" } );
			
		}else {
			
		}
	}
	
	/**
	 * Use this method to register any movieclip as a listener to this class' events
	 * @param	mc - the movieclip that is to be registered
	 */
	public function registerListener(mc:MovieClip) {
		this.addEventListener("ThumbListInit", mc);
		this.addEventListener("ThumbClicked", mc);
	}
	
	/**
	 * Use this function to get the path of the image to be loaded for a particular thumbnail
	 * @param	i - the number of the thumbnail
	 * @return - the path of the image
	 */
	public function imgPath(i:Number):String {
		return this["thumb" + i + "_mc"].imgPath;
	}
	
	public function imgTitle(i:Number):String {
		return this["thumb" + i + "_mc"].imgTitle;
	}
	
	public function imgInfo(i:Number):String {
		return this["thumb" + i + "_mc"].imgInfo;
	}
	
	public function imgID(i:Number):String {
		return this["thumb" + i + "_mc"].ID;
	}
	
	public function imgType(i:Number):String {
		return this["thumb" + i + "_mc"].Type;
	}
	
	public function imgPathByID(id:String):Number {
		for (var i:Number = 0; i < total; i++) 
		{
			if (this["thumb" + i + "_mc"].ID == id) {
				return i;
				break;
			}
		}
		return -1;
	}
	
	private function ThumbClicked(e:Object) {
		isActive = false;
		dispatchEvent( { type:"ThumbClicked", loadObj:e.loadObj } );
	}
	
	private function ThumbLoaded(e:Object) {
		this["thumb" + (1*e.num + 1) + "_mc"].loadThumb();
	}
	
	public function addEventListener() { };
	public function removeEventListener() { };
	private function dispatchEvent() { };
	
	/**
	 * Use this property to get or set wether the list is active or not. This property is used by <i>PhotoRetoucherGallery</i> class to manage the alignments of the list on the stage.
	 */
	public function get isActive():Boolean {
		return _isactive;
	}
	
	public function set isActive(bool:Boolean) {
		_isactive = bool;
	}
	
	/**
	 * Use this property to get the width of the thumbnail. It is set when the gallery xml file is parsed. This property is used by <i>Thumb</i> class to align and scale the thumbnails properly.
	 */
	public function get thumbWidth():Number {
		return _twidth;
	}
	
	/**
	 * Use this property to get the gap between thumbnails alignments. It is set when the gallery xml file is parsed. This property is used by <i>Thumb</i> class to align and scale the thumbnails properly.
	 */
	public function get thumbGap():Number {
		return _gap;
	}
	
	/**
	 * Use this property to get the height of the thumbnail. It is set when the gallery xml file is parsed. This property is used by <i>Thumb</i> class to align and scale the thumbnails properly
	 */
	public function get thumbHeight():Number {
		return _theight;
	}
	
	/**
	 * Use this method to get the number of columns of thumbnails the list has
	 */
	public function get colNum():Number {
		return _col;
	}
	
	/**
	 * Use this method to get the total number of thumbnails
	 */
	public function get totalThumbs():Number {
		return total;
	}
}