﻿import com.maheshj.UI.core.DisplayObject;
import mx.utils.Delegate;

/**
 * This is the class of the contact form. Any changes you need to its functionality can be done here.
 */
class template.Contact extends DisplayObject
{
	
	private var form_mc:MovieClip;
	
	public function Contact() 
	{
		
	}
	
	/**
	 * Use this method to register a movieclip as this class
	 * @param	target - the movieclip to be registered
	 */
	public static function main(target:MovieClip) {
		target.__proto__ = Contact.prototype;
		target.init();
	}
	
	/**
	 * Method used to initialize all the variables, functionality, etc.
	 */
	public function init() {
		
		form_mc.name_txt.condenseWhite = form_mc.email_txt.condenseWhite = form_mc.sub_txt.condenseWhite = form_mc.mes_txt.condenseWhite = true;
		
		form_mc.name_txt.onSetFocus = Delegate.create(this, function() {
			if (form_mc.name_txt.text == "NAME") {
				form_mc.name_txt.text = "";
			}
		});
		
		form_mc.email_txt.onSetFocus = Delegate.create(this, function() {
			if (form_mc.email_txt.text == "E-MAIL") {
				form_mc.email_txt.text = "";
			}
		});
		
		form_mc.sub_txt.onSetFocus = Delegate.create(this, function() {
			if (form_mc.sub_txt.text == "SUBJECT") {
				form_mc.sub_txt.text = "";
			}
		});
		
		form_mc.mes_txt.onSetFocus = Delegate.create(this, function() {
			if (form_mc.mes_txt.text.substr(0,7) == "MESSAGE") {
				form_mc.mes_txt.text = "";
			}
		});
		
		form_mc.name_txt.onKillFocus = Delegate.create(this, function() {
			if (form_mc.name_txt.text == "") {
				form_mc.name_txt.text = "NAME";
			}
		});
		
		form_mc.email_txt.onKillFocus = Delegate.create(this, function() {
			if (form_mc.email_txt.text == "") {
				form_mc.email_txt.text = "E-MAIL";
			}
		});
		
		form_mc.sub_txt.onKillFocus = Delegate.create(this, function() {
			if (form_mc.sub_txt.text == "") {
				form_mc.sub_txt.text = "SUBJECT";
			}
		});
		
		form_mc.mes_txt.onKillFocus = Delegate.create(this, function() {
			if (form_mc.mes_txt.text == "") {
				form_mc.mes_txt.text = "MESSAGE";
			}
		});
		
		form_mc.reset_mc.onRelease = Delegate.create(this, function() {
			form_mc.name_txt.text = "NAME";
			form_mc.email_txt.text = "E-MAIL";
			form_mc.sub_txt.text = "SUBJECT";
			form_mc.mes_txt.text = "MESSAGE";
		});
		
		form_mc.send_mc.onRelease = Delegate.create(this, function() {
			if (form_mc.name_txt.text == "NAME" or form_mc.name_txt.text == " ") {
				form_mc.status_txt.text = "Please enter name";
				return;
			}
			if (form_mc.email_txt.text == "E-MAIL" or form_mc.email_txt.text == " ") {
				form_mc.status_txt.text = "Please enter your email";
				return;
			}
			if (form_mc.sub_txt.text == "SUBJECT" or form_mc.sub_txt.text == " ") {
				form_mc.status_txt.text = "Please enter a subject";
				return;
			}
			if (form_mc.mes_txt.text.substr(0,7) == "MESSAGE" or form_mc.mes_txt.text == " ") {
				form_mc.status_txt.text = "Please enter a message";
				return;
			}
			var email:String = form_mc.email_txt.text;
			if ((email.length<6) || (email.indexOf(",")>=0) || (email.indexOf(";")>=0) || (email.indexOf(":")>=0) || (email.indexOf("/")>=0) || (email.indexOf(" "	)>=0) || (email.indexOf("@")<=0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.lastIndexOf(".")<email.indexOf("@")) || ((email.lastIndexOf(".")+3)>email.length)) {
				form_mc.status_txt.text = "Please enter a valid email address";
				return;
			}
			loadVariables("email.php?name=" + form_mc.name_txt.text + "&email=" + form_mc.email_txt.text + "&subject=" + form_mc.sub_txt.text + "&message=" + form_mc.mes_txt.text, this, "GET");
			this.onData = function() {
				if (this.result.substr(0,6) != "failed") {
					form_mc.status_txt.text = "Message successfully sent";
				} else {
					form_mc.status_txt.text = "Error sending message. Please try again";
				}
			};
		});
		
		enter();
		super.init();
	}
	
	/**
	 * Call this function to make the form appear. The "in" animation is made on the timeline in the registered movieclip
	 */
	public function enter() {
		gotoAndPlay("in");
	}
	
	/**
	 * Call this function for the exit transition of the contact form. The "out" animation is made on the timeline in the registered movieclip
	 */
	public function exit() {
		gotoAndPlay("out");
	}
	
}