﻿import com.maheshj.utils.mp3.PlayList;
import com.maheshj.utils.mp3.PlaylistItem;
import mx.utils.Delegate;
import com.maheshj.utils.mp3.Mp3PlayBackManager;
import caurina.transitions.*;

/**
 * This class is atached to the movieclip that needs to behave like a music player.
 */
class template.MP3Player extends MovieClip
{
	
	private var playman:Mp3PlayBackManager;
	private var ul_mc:MovieClip;
	private var label_txt:TextField;
	
	/**
	 * The constructor
	 */
	public function MP3Player() 
	{
		playman = new Mp3PlayBackManager();
		
		ul_mc._visible = false;
		
		onRollOver = Delegate.create(this, function() {
			ul_mc._visible = true;
			Tweener.addTween(ul_mc, { _width:label_txt._width-3.5, time:0.6, transition:"easeOutQuint" } );
		});
		
		onRollOut = onReleaseOutside = Delegate.create(this, function() {
			Tweener.addTween(ul_mc, { _width:1, time:0.3, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
				ul_mc._visible = false;
			}) } );
		});
		
		onRelease = Delegate.create(this, function() {
			playman.togglePlayBack();
		});
	}
	
	/**
	 * Call this function to start playing the music
	 */
	public function playMusic() {
		playman.playMusic();
	}
	
	/**
	 * Use this method to set a new track for the mp3 player
	 */
	public function set track(path:String) {
		var myarr:PlayList = new PlayList();
		myarr.addItem(new PlaylistItem(path));
		playman.playlist = myarr;
	}
	
}