﻿import com.maheshj.UI.core.GenericMenuItem;
import mx.utils.Delegate;
import caurina.transitions.*;
import template.MenuItemInitData;

/**
 * This is the main menu item class for the template. The following events are dispatched by this class:<br/><br/>
 * <b><i>MenuItemClicked</i></b> - dispatched when the a menu item is clicked.<br/><br/>
 */
class template.MainMenuItem extends GenericMenuItem
{
	
	private var label_txt:TextField;
	private var initobj:MenuItemInitData;
	private var isActive:Boolean;
	private var ul_mc:MovieClip;
	
	/**
	 * The constructor.
	 */
	public function MainMenuItem() 
	{
		ul_mc._visible = false;
		
		initobj = new MenuItemInitData();
		
		onRollOver = Delegate.create(this, function() {
			ul_mc._visible = true;
			Tweener.addTween(ul_mc, { _width:label_txt._width-3.5, time:0.6, transition:"easeOutQuint" } );
		});
		
		onRollOut = onReleaseOutside = Delegate.create(this, function() {
			if(!isActive)
			Tweener.addTween(ul_mc, { _width:1, time:0.3, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
				ul_mc._visible = false;
			}) } );
		});
		
		onRelease = Delegate.create(this, function() {
			triggerRelease();
		});
	}
	
	/**
	 * Method used to initialize all the variables, functionality, etc.
	 * @param	initobj - the object containing he required variables for the menu item to initialize
	 */
	public function init(initobj:MenuItemInitData) {
		label_txt.autoSize = true;
		label_txt.text = initobj.title;
		this.initobj = initobj;
	}
	
	/**
	 * Use this method to register any movieclip as a listener to the events of this class.
	 * @param	mc - the movieclip that is to be registered
	 */
	public function registerListener(mc:MovieClip) {
		this.addEventListener("MenuItemClicked", mc);
	}
	
	/**
	 * call this function to make the menu item appear
	 */
	public function enter() {
		Tweener.addTween(ul_mc, { _width:1, time:0.3, transition:"easeInOutQuint", onComplete:Delegate.create(this, function() {
			ul_mc._visible = false;
		}) } );
		enabled = true;
		isActive = false;
	}
	
	/**
	 * Use this function to trigger a MenuItemClicked event without actually clicking on the menu item
	 */
	public function triggerRelease() {
		if (initobj.type == "link") {
			getURL(initobj.file, "_blank");
		}else {
			isActive = true;
			dispatchEvent( { type:"MenuItemClicked", itemObj:initobj } );
		}
	}
	
	/**
	 * Use this property to get the menu item variables
	 */
	public function get itemObj():MenuItemInitData {
		isActive = true;
		ul_mc._visible = true;
		Tweener.addTween(ul_mc, { _width:label_txt._width-3.5, time:0.6, transition:"easeOutQuint" } );
		enabled = false;
		return initobj;
	}
	
	/**
	 * Use this property to get the unique ID of the menu item
	 */
	public function get ID():String {
		return initobj.ID;
	}
	
}