﻿import mx.events.EventDispatcher;

/**
 * This class is used to do the basic stage event handling for the template.<br/><br/>The following events are dispatched by this class:<br/><br/>
 * <b><i>StageResized</i></b> - dispatched when the stage is resized.<br/><br/>
 */
class template.StageManager {
	
	private static var EventDispatcherDependancy = EventDispatcher.initialize(StageManager.prototype); 
	public var addEventListener:Function; 
	public var removeEventListener:Function; 
	public var dispatchEvent:Function;
	
	/**
	 * The constructor. Sets the stage align mode to "TL" (Top Left) and the scaleMode to "noScale". Also adds the passed movieclip to the stage's listeners list.
	 * @param	target - the movieclip
	 */
	public function StageManager(target:MovieClip) {
		
		Stage.align = "TL";
        Stage.scaleMode = "noScale";
		
		Stage.addListener(this);
		this.addEventListener("StageResized", target);
	}
	
	/**
	 * Stage listener.
	 */
	public function onResize(){
		dispatchEvent( { type:"StageResized" } );
	}
}